"""
HB_AxisSnap V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_AxisSnap

Description-US: Enables Axis Snap and disables all other Snapping Modes. [SHIFT-CLICK: Axis Snap additional, CTRL-Click: Disable Axis Snap]

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=27m25s


ChangeLog:

Jun/11/2015 V1.0
- Release Version 504566338友情分享

Oct/11/2018 V1.1
- new Highres Icon

"""

import c4d
from c4d.modules import snap


def main():
    
    if not (c4d.IsCommandChecked(440000121)):
        c4d.CallCommand(440000121) # Snapping on
    
    bc = c4d.BaseContainer()
    mysettings_bc=c4d.BaseContainer()
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):
        
        if bc[c4d.BFM_INPUT_QUALIFIER] ==0 :
            
            c4d.CallCommand(c4d.SNAP_SETTINGS_AUTO)
            
            snap.EnableSnap(False, doc, c4d.SNAPMODE_POINT)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_EDGE)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_POLYGON)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_SPLINE)
            snap.EnableSnap(True, doc, c4d.SNAPMODE_AXIS)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_INTERSECTION)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_MIDPOINT)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_WORKPLANE)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_GUIDE)
        
        if bc[c4d.BFM_INPUT_QUALIFIER] ==1 :
            snap.EnableSnap(True, doc, c4d.SNAPMODE_AXIS)
            
        if bc[c4d.BFM_INPUT_QUALIFIER] ==2 :
            snap.EnableSnap(False, doc, c4d.SNAPMODE_AXIS)
    
    
    c4d.EventAdd()

if __name__=='__main__':
    main()
